/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla.type;

import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import org.jetbrains.annotations.Nullable;

public class IngredientList
implements CraftTweakerVanillaIngredient {
    private final List<class_1856> children;
    private final boolean requiresTesting;

    public static IngredientList of(List<class_1856> children) {
        return new IngredientList(children);
    }

    public static class_1856 ingredient(List<class_1856> children) {
        return Services.PLATFORM.getIngredientList(children);
    }

    private IngredientList(List<class_1856> children) {
        this.children = children;
        this.requiresTesting = children.stream().anyMatch(Services.PLATFORM::doesIngredientRequireTesting);
    }

    @Override
    public boolean test(@Nullable class_1799 stack) {
        if (stack == null) {
            return false;
        }
        return this.children.stream().anyMatch(child -> child.method_8093(stack));
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        return this.getChildren().stream().map(class_1856::method_8105).flatMap(Arrays::stream).toList();
    }

    @Override
    public boolean requiresTesting() {
        return this.requiresTesting;
    }

    @Override
    public boolean isEmpty() {
        return this.getChildren().stream().allMatch(class_1856::method_8103);
    }

    public List<class_1856> getChildren() {
        return this.children;
    }

    public IngredientListSerializer serializer() {
        return IngredientListSerializer.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngredientList that = (IngredientList)o;
        return this.requiresTesting == that.requiresTesting && Objects.equals(this.getChildren(), that.getChildren());
    }

    public int hashCode() {
        return Objects.hash(this.getChildren(), this.requiresTesting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IngredientList{");
        sb.append("children=").append(this.children);
        sb.append(", requiresTesting=").append(this.requiresTesting);
        sb.append('}');
        return sb.toString();
    }
}

